package com.bxm.localnews.thirdparty.service;

import com.bxm.localnews.thirdparty.dto.WxUserInfo;

import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;

/**
 * @author zhaoyadong 2018/10/17 16:42
 * @desc
 */
public interface WxMpAuthService {

    /**
     * 根据code获取微信用户信息
     *
     * @param code
     * @return
     */
    WxUserInfo getUserByCode(String code, String type);

    /**
     * 获取用户列表
     *
     * @param nextOpenId
     * @return
     */
    WxMpUserList getUserList(String nextOpenId);

    /**
     * 获取用户信息
     *
     * @param openId
     * @return
     */
    WxMpUser getUser(String openId);

    /**
     * 获取微信js签名验证
     *
     * @param url
     * @return
     */
    WxJsapiSignature getWxJsapiSignature(String url, String type);
}
