package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.thirdparty.config.DomainProperties;
import com.bxm.localnews.thirdparty.service.AllotDomainService;
import com.bxm.newidea.component.tools.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Random;

/**
 * @author zhaoyadong 2019/3/26 15:52
 * @desc
 */
@Service

public class AllotDomainServiceImpl implements AllotDomainService {

    @Autowired
    private DomainProperties domainProperties;

    @Override
    public String getRandomDomain() {
        Random random = new Random();
        List<String> domainList = domainProperties.getInfoList();

        return CollectionUtils.isEmpty(domainList) ? StringUtils.EMPTY :
                domainList.get(random.ints(0, domainList.size()).findFirst().getAsInt());
    }
}
