package com.bxm.localnews.thirdparty.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.thirdparty.domain.BannerMapper;
import com.bxm.localnews.thirdparty.service.BannerService;
import com.bxm.localnews.thirdparty.vo.Banner;
import com.github.pagehelper.PageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/2/7 0007.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BannerServiceImpl implements BannerService {

    private BannerMapper bannerMapper;

    @Autowired
    public BannerServiceImpl(BannerMapper bannerMapper) {
        this.bannerMapper = bannerMapper;
    }

    @Override
    public List<Banner> queryBannerList(Byte bannerType) {
        return this.bannerMapper.queryList(bannerType);
    }

    @Override
    public List<Banner> listBanner(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage(current, pageSize);
        List<Banner> list = this.bannerMapper.findBySelective(searchMap);
        return list;
    }

    @Override
    public Json insertSelective(Banner Banner, Integer functionId) {
        Banner.setAddTime(new Date());
        this.bannerMapper.insertSelective(Banner);
        return ResultUtil.genSuccessMsg();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Json updateBySelective(Banner Banner, Integer functionId) {
        Banner.setUpdateTime(new Date());
        this.bannerMapper.updateByPrimaryKeySelective(Banner);
        return ResultUtil.genSuccessMsg();
    }

    @Override
    public Json changeState(Long bannerId, String status) {
        Banner bannerInfo = this.bannerMapper.selectByPrimaryKey(bannerId.intValue());
        if (bannerInfo == null) {
            return ResultUtil.genFailedResult("操作失败,无该功能");
        }
        bannerInfo.setStatus(Byte.valueOf(status));
        bannerInfo.setUpdateTime(new Date());
        int i = this.bannerMapper.updateByPrimaryKeySelective(bannerInfo);
        if (i > 0) {
            return ResultUtil.genSuccessMsg();
        }
        return ResultUtil.genFailedResult("系统异常,请联系管理员");
    }

    @Override
    public Banner getBanner(Integer bannerId) {

        return this.bannerMapper.selectByPrimaryKey(bannerId);
    }

    @Override
    public int updateBannerStatusByIds(Long[] ids, Byte status) {
        return this.bannerMapper.updateBannerStatusByIds(ids, status);
    }

}
