package com.bxm.localnews.thirdparty.service.impl;

import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.util.SHASign;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.thirdparty.config.KnowledgeProperties;
import com.bxm.localnews.thirdparty.service.PayKnowledgeService;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("payKnowledgeService")
public class PayKnowledgeServiceImpl implements PayKnowledgeService {

    private HttpClientService httpClientService;

    private UserIntegrationService userIntegrationService;

    private KnowledgeProperties knowledgeProperties;

    @Autowired
    public PayKnowledgeServiceImpl(HttpClientService httpClientService, UserIntegrationService userIntegrationService,
                                   KnowledgeProperties knowledgeProperties) {
        this.httpClientService = httpClientService;
        this.userIntegrationService = userIntegrationService;
        this.knowledgeProperties = knowledgeProperties;
    }

    @Override
    public String exemptPayKnowledgeLogin(Long userId, Integer isLogin, String redirectUrl) {
        if (isLogin == 0) {
            return knowledgeProperties.getJumpUrl();
        }
        //封装参数
        HashMap<String, String> map = generateExepmtLoginParams(userId);

        //解析请求返回结果
        String jsonResult = httpClientService.doPostJson(knowledgeProperties.getUrl(),
                JSONObject.toJSONString(map));
        String jumpUrl = getUrlByResult(jsonResult, redirectUrl);

        return jumpUrl;
    }

    /**
     * 构建获取免登陆的必须的参数
     *
     * @param userId
     * @return 返回对参数进行封装后的map
     */
    private HashMap<String, String> generateExepmtLoginParams(Long userId) {
        UserInfoDTO dto = userIntegrationService.getUserFromRedisDB(userId);
        HashMap<String, String> map = Maps.newHashMap();
        map.put("uid", userId.toString());
        if (dto == null) {
            map.put("nickname", "");
            map.put("headImgUrl", "");
            map.put("nickname", "");
        } else {
            map.put("nickname", null == dto.getNickname() ? "" : dto.getNickname());
            map.put("headImgUrl", null == dto.getHeadImg() ? "" : dto.getHeadImg());
        }
        map.put("appKey", knowledgeProperties.getAppKey());
        String signature = SHASign.sign(map, knowledgeProperties.getAppSecret());
        map.put("signature", signature);

        return map;
    }

    /**
     * 根据返回的json解析跳转的url
     *
     * @param jsonResult
     * @param redirectUrl
     * @return 返回知识付费的入口url
     */
    private String getUrlByResult(String jsonResult, String redirectUrl) {
        JSONObject jsonObject = JSONObject.parseObject(jsonResult).getJSONObject("result");
        String type = jsonObject.getString("type");
        String backUserId = jsonObject.getString("userId");
        String token = jsonObject.getString("token");
        StringBuilder jumpUrl = new StringBuilder().append(knowledgeProperties.getJumpUrl()).append("?").append("token=")
                .append(type).append("_").append(backUserId).append("_").append(token);

        if (StringUtils.isNotBlank(redirectUrl)) {
            jumpUrl.append(redirectUrl);
        }
        return jumpUrl.toString();
    }

    /**
     * 根据重定向地址获取对应的参数值
     *
     * @param redirectUrl
     * @return
     */
    private String getTypeByRedirectUrl(String redirectUrl) {
        String str = StringUtils.substringAfterLast(redirectUrl, "?");
        Map<String, String> map = Splitter.on("&").withKeyValueSeparator("=").split(str);
        return map.get("type");
    }
}
