package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.service.PushMessageService;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service
public class PushMessageServiceImpl implements PushMessageService {

    private Logger LOG = LoggerFactory.getLogger(PushMessageServiceImpl.class);

    private final static String WE_CHAT_PUSH_URL = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send";

    @Autowired
    private WechatService wechatService;

    @Autowired
    private WechatProperties wechatProperties;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private HttpClientService httpClientService;

    @Autowired
    private UserAuthIntegrationService userAuthIntegrationService;

    @Override
    public void pushMessage(BigDecimal cash, Long userId) {
        if (null == userId || null == cash) {
            return;
        }
        UserAuth userAuth = userAuthIntegrationService.selectAppletUserAuthByUserId(userId);
        if (null == userAuth) {
            return;
        }
        KeyGenerator key = RedisConfig.WEIXIN_FORMID.copy().appendKey(userId);
        String userFormId = redisStringAdapter.get(key, String.class);
        if (userFormId == null) {
            return;
        }

        // 推送微信消息
        JSONObject data = new JSONObject();
        JSONObject keyword1 = new JSONObject();
        JSONObject keyword2 = new JSONObject();
        keyword1.put("value", "入账" + cash.stripTrailingZeros().toPlainString() + "元");
        keyword2.put("value", "分享越多奖金越多，点击去提现");
        data.put("keyword1", keyword1);
        data.put("keyword2", keyword2);

        // 条件
        JSONObject parameters = new JSONObject();
        parameters.put("access_token", wechatService.getWeChatToken());
        parameters.put("touser", userAuth.getIdentifier());
        parameters.put("template_id", wechatProperties.getTemplateId());
        parameters.put("form_id", userFormId);
        parameters.put("data", data);
        parameters.put("emphasis_keyword", "keyword1.DATA");
        String page = wechatProperties.getPushPage();
        if (!page.endsWith("?")) {
            page += "?";
        }
        page += "inviteUserId=";
        parameters.put("page", page);
        if (LOG.isDebugEnabled()) {
            LOG.debug("weChat push params:{}", parameters);
        }
        try {
            JSONObject result = JSON.parseObject(httpClientService.doPostJson(
                    WE_CHAT_PUSH_URL + "?access_token=" + wechatService.getWeChatToken(), parameters.toJSONString()));
            LOG.info("weChat push result:{}", result.toJSONString());
        } catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.info("weChat push error", e);
            }
            return;
        }
    }

}
