package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.UserParam;
import com.bxm.localnews.thirdparty.config.WechatProperties;
import com.bxm.localnews.thirdparty.constant.InviteTypeEnum;
import com.bxm.localnews.thirdparty.dto.WechatDto;
import com.bxm.localnews.thirdparty.dto.WxUserInfo;
import com.bxm.localnews.thirdparty.service.WechatService;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.qq.weixin.mp.aes.AES;
import me.chanjar.weixin.common.util.crypto.PKCS7Encoder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

@Service
public class WechatServiceImpl implements WechatService {
    private static final Logger logger = LoggerFactory.getLogger(WechatServiceImpl.class);

    private static final String WATERMARK = "watermark";

    private static final String APPID = "appid";

    private static final String WE_CHAT_URL = "https://api.weixin.qq.com/cgi-bin/token";

    private static final String GRANT_TYPE = "client_credential";

    /**
     * 微信登录凭证校验
     */
    private final String url = "https://api.weixin.qq.com/sns/jscode2session?appid={appid}&secret={secret}&js_code={js_code}&grant_type=authorization_code";

    /**
     * 获取微信小程序分享二维码的地址
     */
    private final String qrUrl = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token={}";

    private RedisStringAdapter redisStringAdapter;

    private WechatProperties wechatProperties;

    private HttpClientService httpClientService;

    private AliyunOSSService aliyunOSSService;

    private UserIntegrationService userIntegrationService;

    private UserAuthIntegrationService userAuthIntegrationService;

    private JSONObject token_json;

    @Autowired
    public WechatServiceImpl(HttpClientService httpClientService, WechatProperties wechatProperties,
                             AliyunOSSService aliyunOSSService, UserIntegrationService userIntegrationService,
                             UserAuthIntegrationService userAuthIntegrationService, RedisStringAdapter redisStringAdapter) {
        this.httpClientService = httpClientService;
        this.wechatProperties = wechatProperties;
        this.aliyunOSSService = aliyunOSSService;
        this.userIntegrationService = userIntegrationService;
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public WxUserInfo getWechatInfo(WechatDto wechatDto) {
        WxUserInfo wxUserInfo = new WxUserInfo();
        String code = wechatDto.getCode();
        if (StringUtils.isNotEmpty(code)) {
            String requestUrl = url.replace("{js_code}", code)
                    .replace("{appid}", wechatProperties.getAppId())
                    .replace("{secret}", wechatProperties.getSecret());
            JSONObject jsonObject = JSON.parseObject(httpClientService.doGet(requestUrl));
            if (logger.isDebugEnabled()) {
                logger.debug("code 获取openid 结果： " + jsonObject.toJSONString());
            }
            // 微信用户唯一标识
            String openId = jsonObject.getString("openid");
            wxUserInfo.setOpenId(openId);
            // 微信会话密钥
            wxUserInfo.setSessionKey(jsonObject.getString("session_key"));
            // 微信用户在开放平台的唯一标识符
            wxUserInfo.setUnionId(jsonObject.getString("unionid"));

            if (null != openId) {
                UserAuth userAuth = userAuthIntegrationService.selectAppletUserAuthByOpenId(openId);
                if (null != userAuth) {
                    wxUserInfo.setUserId(userAuth.getUserId());
                    if (null != userAuth.getUserId()) {
                        UserInfoDTO userInfo = userIntegrationService.getUserFromRedisDB(userAuth.getUserId());
                        if (userInfo != null) {
                            wxUserInfo.setNickname(userInfo.getNickname());
                            wxUserInfo.setHeadImg(userInfo.getHeadImg());
                        }
                    }
                }
            }
        }

        return wxUserInfo;
    }

    @Override
    public String getWechatQRCode(WechatDto wechatDto) {
        String weChatToken = getWeChatToken();
        if (logger.isDebugEnabled()) {
            logger.debug("wechat token : " + weChatToken);
        }
        String requestUrl = qrUrl.replace("{}", weChatToken);

        JSONObject param = new JSONObject();
        param.put("scene", wechatDto.getScene());
        param.put("page", wechatDto.getPage());
        param.put("width", wechatDto.getWidth());
        param.put("auto_color", wechatDto.getAutoColor());
        JSONObject jsonLineColor = JSON.parseObject(wechatDto.getLineColor());
        Map<String, Object> innerMap = jsonLineColor.getInnerMap();
        param.put("line_color", innerMap);
        param.put("is_hyaline", wechatDto.getHyaline());

        String result = httpPost(requestUrl, param, wechatDto.getInviteUserId());
        return result;
    }

    @Override
    public String createUser(String encryptedData, String sessionKey, String iv, Long inviteUserId, String ip, String platform, String area) {
        try {
            AES aes = new AES();
            byte[] resultByte = aes.decrypt(Base64.decodeBase64(encryptedData), Base64.decodeBase64(sessionKey), Base64.decodeBase64(iv));
            if (null != resultByte && resultByte.length > 0) {
                String result = new String(PKCS7Encoder.decode(resultByte));
                JSONObject jsonObject = JSON.parseObject(result);
                String decryptAppid = jsonObject.getJSONObject(WATERMARK).getString(APPID);
                if (wechatProperties.getAppId().equals(decryptAppid)) {
                    UserParam userParam = new UserParam();
                    userParam.setOpenId(jsonObject.getString("openId"));
                    userParam.setUnionId(jsonObject.getString("unionId"));
                    userParam.setHeadImg(jsonObject.getString("avatarUrl"));
                    userParam.setNickName(jsonObject.getString("nickName"));
                    userParam.setSex(jsonObject.getByte("gender"));

                    userParam.setRegIp(ip);
                    userParam.setPlatform(platform);
                    userParam.setRegisteredAddress(area);
                    userParam.setInviteUserId(inviteUserId);
                    userParam.setInviteType(InviteTypeEnum.APPLETDRAW.name());

                    Message message = userIntegrationService.createUser(userParam);
                    if (message != null && message.isSuccess()) {
                        return ObjectUtils.toString(message.getParamMap().get("userId"));
                    }
                }
            }
        } catch (Exception e) {
            logger.error("创建用户失败：", e);
        }

        return "";
    }

    @Override
    public Boolean setUserFormId(Long userId, String formId) {
        KeyGenerator key = RedisConfig.WEIXIN_FORMID.copy().appendKey(userId);
        redisStringAdapter.set(key, formId);

        return true;
    }

    /**
     * 生成解析微信二维码post请求
     *
     * @param url
     * @param jsonParam
     * @param inviteUserId
     */
    private String httpPost(String url, JSONObject jsonParam, Long inviteUserId) {
        // post请求返回结果
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(HTTP.CONTENT_TYPE, "application/json");
        // 设置请求和传输超时时间
        httpPost.setConfig(RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build());

        logger.info("getWechatQRCode url is:{},jsonParam is:{}", url, jsonParam);
        try {
            String imgName = DateUtils.formatDate(new Date()) + "/" + UUID.randomUUID() + "-" + inviteUserId + ".png";

            if (null != jsonParam) {
                // 解决中文乱码问题
                StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("image/png");
                httpPost.setEntity(entity);
            }
            CloseableHttpResponse response = httpClient.execute(httpPost);
            InputStream inputStream = response.getEntity().getContent();

            String path = aliyunOSSService.upload(inputStream, "/qr/" + imgName);

            // 请求发送成功，并得到响应
            return path;
        } catch (IOException e) {
            logger.error("post请求提交失败:" + url, e);
        } finally {
            httpPost.releaseConnection();
        }
        return null;
    }

    @Override
    public String getWeChatToken() {
        try {
            // 获取缓存中的 token
            if (null != this.token_json) {
                // 超过了120分钟则需要重新请求
                if (null != this.token_json.get("timestamp")
                        && (int) ((System.currentTimeMillis()
                        - Long.parseLong(String.valueOf(this.token_json.get("timestamp"))))
                        / 1000) <= 30 * 60) {
                    if (null != this.token_json.get("access_token")) {
                        return this.token_json.get("access_token").toString();
                    } else {
                        logger.error("get access_token error! errorCode:{} ,errorMsg:{} ",
                                this.token_json.get("errcode"), this.token_json.get("errmsg"));
                    }
                }
            }

            // 如果缓存中的 token 为空，则调用微信接口
            StringBuffer url = new StringBuffer();
            // 微信 access_token 请求url
            url.append(WE_CHAT_URL).append("?");
            // 微信 access_token 请求参数
            url.append("grant_type=").append(GRANT_TYPE);
            url.append("&").append("appid=").append(wechatProperties.getAppId());
            url.append("&").append("secret=").append(wechatProperties.getSecret());

            JSONObject jsonObject = JSON.parseObject(httpClientService.doGet(url.toString()));
            if (null != jsonObject) {
                if (null != jsonObject.get("access_token")) {
                    jsonObject.put("timestamp", System.currentTimeMillis());
                    this.token_json = jsonObject;
                    return String.valueOf(jsonObject.get("access_token"));
                } else {
                    logger.info("get access_token from weChat error! errorCode:{} ,errorMsg:{} ",
                            jsonObject.get("errcode"), jsonObject.get("errmsg"));
                }
            }
        } catch (Exception e) {
            logger.error("getWeChatToken system error", e);
        }

        return null;
    }

    @Override
    public void emptyWeChatToken() {
        this.token_json = null;
    }
}
