/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.thirdparty.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.thirdparty.config.RecruitProperties;
import com.bxm.localnews.thirdparty.dto.RecruitDTO;
import com.bxm.localnews.thirdparty.service.BlueCollarService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueCollarServiceImpl
implements BlueCollarService {
    private static final String params = "?isLogin={isLogin}&userId={userId}&addressLon={lng}&addressLat={lat}&areaCode={areaCode}&areaName={areaName}&workType={workType}";
    private HttpClientService httpClientService;
    private RecruitProperties recruitProperties;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public BlueCollarServiceImpl(HttpClientService httpClientService, RecruitProperties recruitProperties, RedisStringAdapter redisStringAdapter) {
        this.httpClientService = httpClientService;
        this.recruitProperties = recruitProperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public RecruitDTO getRecruits(String areaCode) {
        RecruitDTO recruitDTO = (RecruitDTO)this.redisStringAdapter.get(this.getRecruitKey(areaCode), RecruitDTO.class);
        if (recruitDTO == null) {
            recruitDTO = this.getRecruitByAreaCode(areaCode);
        }
        recruitDTO.setRedirectUrl(recruitDTO.getRedirectUrl() + params);
        return recruitDTO;
    }

    private RecruitDTO getRecruitByAreaCode(String areaCode) {
        RecruitDTO recruitDTO = new RecruitDTO();
        HashMap map = Maps.newHashMap();
        map.put("areaCode", areaCode);
        map.put("limitSize", this.recruitProperties.getLimitSize().toString());
        String json = this.httpClientService.doGet(this.recruitProperties.getUrl(), (Map)map);
        if (StringUtils.isBlank((CharSequence)json)) {
            return recruitDTO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (!jsonObject.getBoolean("successed").booleanValue()) {
            return recruitDTO;
        }
        JSONObject jo = jsonObject.getJSONObject("returnValue");
        TypeReference<RecruitDTO> typeReference = new TypeReference<RecruitDTO>(){};
        recruitDTO = (RecruitDTO)JSON.parseObject((String)jo.toJSONString(), (TypeReference)typeReference, (Feature[])new Feature[0]);
        this.redisStringAdapter.set(this.getRecruitKey(areaCode), (Object)recruitDTO, 300L);
        return recruitDTO;
    }

    private KeyGenerator getRecruitKey(String areaCode) {
        KeyGenerator key = RedisConfig.THIRDPARTY_RECRUIT.copy().appendKey((Object)areaCode);
        return key;
    }
}

