package com.bxm.localnews.user.event.stream;

import org.springframework.cloud.stream.annotation.Output;
import org.springframework.messaging.MessageChannel;

/**
 * spring cloud steam的输出通道定义
 * 配置
 *
 * @author liujia
 * @date 2020-07-16 15:30
 **/
public interface MessageProcessor {

    /**
     * 用户定位行为变更消息
     */
    String LOCATION_ACTION_OUTPUT = "locationActionOutput";

    /**
     * 用户属性变更消息
     */
    String ATTRIBUTE_ACTION_OUTPUT = "attributeActionOutput";

    /**
     * 用户冗余信息更新消息
     */
    String REDUNDANCY_ACTION_OUTPUT = "redundancyActionOutput";

    /**
     * 用户活跃与实时定位
     */
    String ACTIVE_ACTION_OUTPUT = "activeActionOutput";

    @Output(MessageProcessor.LOCATION_ACTION_OUTPUT)
    MessageChannel locationActionOutput();

    @Output(MessageProcessor.ATTRIBUTE_ACTION_OUTPUT)
    MessageChannel attributeActionOutput();

    @Output(MessageProcessor.REDUNDANCY_ACTION_OUTPUT)
    MessageChannel redundancyActionOutput();

    @Output(MessageProcessor.ACTIVE_ACTION_OUTPUT)
    MessageChannel activeActionOutput();
}
