/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.event.config;

import com.bxm.localnews.user.event.stream.MessageProcessor;
import com.bxm.localnews.user.event.subscribe.UserActionStreamSubscriber;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableBinding(value={MessageProcessor.class})
public class UserActionConfiguration {
    @Bean
    public EventBus userActionEventBus(UserActionStreamSubscriber userActionStreamSubscriber) {
        AsyncEventBus eventBus = new AsyncEventBus("userActionEventBus", (Executor)this.userActionThreadPool());
        eventBus.register((Object)userActionStreamSubscriber);
        return eventBus;
    }

    @Bean
    public ThreadPoolTaskExecutor userActionThreadPool() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(5);
        taskExecutor.setQueueCapacity(5000);
        taskExecutor.setMaxPoolSize(50);
        taskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        taskExecutor.setThreadFactory((ThreadFactory)new NamedThreadFactory("user-action-task"));
        taskExecutor.initialize();
        return taskExecutor;
    }
}

