/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.event.subscribe;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.user.event.UserActionEvent;
import com.bxm.localnews.user.event.stream.MessageProcessor;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.stereotype.Component;

@Component
public class UserActionStreamSubscriber {
    private static final Logger log = LoggerFactory.getLogger(UserActionStreamSubscriber.class);
    private final MessageProcessor messageProcessor;

    @Autowired
    public UserActionStreamSubscriber(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    @Subscribe
    public void consume(UserActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("\u6d88\u8d39\u7528\u6237\u884c\u4e3a\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)event));
        }
        switch (event.getAction()) {
            case LOCATION: {
                this.messageProcessor.locationActionOutput().send(MessageBuilder.withPayload((Object)event).build());
                break;
            }
            case ATTRIBUTE: {
                this.messageProcessor.attributeActionOutput().send(MessageBuilder.withPayload((Object)event).build());
                break;
            }
            case REDUNDANCY: {
                this.messageProcessor.redundancyActionOutput().send(MessageBuilder.withPayload((Object)event).build());
                break;
            }
            case ACTIVE: {
                this.messageProcessor.activeActionOutput().send(MessageBuilder.withPayload((Object)event).build());
                break;
            }
            default: {
                log.info("\u7528\u6237\u884c\u4e3a\u4e8b\u4ef6\u672a\u5b9a\u4e49\uff1a{}", (Object)JSON.toJSONString((Object)event));
            }
        }
    }
}

