package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.integration.SmsIntegrationService;
import com.bxm.localnews.user.param.UserParam;
import com.bxm.localnews.user.service.DeprecatedService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

@RestController
@RequestMapping()
public class DeprecatedController extends BaseController {

    @Autowired
    private DeprecatedService deprecatedService;

    @Autowired
    private UserService userService;

    @Resource
    private SmsIntegrationService smsIntegrationService;

    @ApiOperation(value = "9-02-10 【个人资料】获取用户基本信息", notes = "包含 头像、昵称、性别、生日、地址、兴趣标签,不用了，操")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "api/user/getUserBaseInfo", method = RequestMethod.GET)
    @Deprecated
    /**
     * @see UserPersonalInfoController
     */
    public Json<UserInfoDTO> getUserBaseInfo(@RequestParam(value = "userId") long userId) {
        return ResultUtil.genSuccessResult(this.userService.getUserFromRedisDB(userId));
    }

    @ApiOperation(value = "9-02-11 更新用户信息", notes = "目前支持 性别、生日、地址、昵称、头像、手机号、个人简介",hidden = true)
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "api/user/updateUserInfo", method = RequestMethod.POST)
    @Deprecated
    /**
     * @see UserPersonalInfoController
     */
    public Json updateUserInfo(UserParam user) {
        Message message = this.deprecatedService.updateUserInfo(user, user.getUserId(), user.getFile());
        if (message.isSuccess()) {
            Map<String, Object> paramMap = message.getParamMap();
            UserInfoDTO userInfoDTO = (UserInfoDTO) paramMap.get("user");
            return ResultUtil.genSuccessResult(userInfoDTO);
        }
        return Json.build(message);
    }

    @ApiOperation(value = "9-02-15 获取用户头像的文件流", notes = "不再推荐调用，修改为9-2-18接口")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", dataType = "long")
    })
    @GetMapping("api/user/userInfo/img")
    @Deprecated
    public void getPrivilegeImg(@RequestParam(name = "userId") Long userId, HttpServletResponse response) throws IOException {
        UserInfoDTO userInfoDTO = this.userService.getUserFromRedisDB(userId);
        if (userInfoDTO == null) {
            return;
        }
        String urlString = userInfoDTO.getHeadImg();
        if (StringUtils.isBlank(urlString)) {
            return;
        }
        String fileName = urlString.substring(urlString.lastIndexOf('/') + 1);
        URL url = new URL(urlString);

        try (BufferedInputStream dis = new BufferedInputStream(url.openStream());
             BufferedOutputStream fos = new BufferedOutputStream(response.getOutputStream())) {
            //避免空行
            response.reset();
            String contentType = FileTypeEnum.getContentType(urlString.substring(urlString.lastIndexOf('.') + 1));
            if (StringUtils.isBlank(contentType)) {
                contentType = "image/jpeg";
            }
            response.setContentType(contentType);
            response.setHeader("Content-disposition", "attachment; filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
            response.setHeader("Content-Length", String.valueOf(url.openConnection().getContentLength()));

            byte[] buff = new byte[2048];
            int bytesRead;
            while (-1 != (bytesRead = dis.read(buff, 0, buff.length))) {
                fos.write(buff, 0, bytesRead);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

//    @ApiOperation(value = "9-02-4 获取绑定手机号码的验证码", notes = "")
//    @ApiImplicitParam(name = "phone", value = "手机号")
//    @PostMapping("api/user/getBindPhoneCode")
//    @Deprecated
//    public SmsJson getVerificationCode(String phone, HttpServletRequest httpServletRequest) {
//        if (!Validater.checkPhone(phone)) {
//            return SmsJson.build(ResultUtil.genFailedResult(BAD_REQUEST, "手机号码格式错误"));
//        }
//        SmsSupplyDTO smsSupplyDTO = new SmsSupplyDTO();
//        smsSupplyDTO.setPhoneNo(phone);
//        smsSupplyDTO.setSmsTemplateEnum(SmsTemplateEnum.BINDING_PHONE);
//        smsSupplyDTO.setIp(WebUtils.getIpAddr(httpServletRequest));
//        SendSmsResult result = this.smsIntegrationService.sendSmsByVCodeTemplate(smsSupplyDTO);
//
//        int respCode = RespCode.OK;
//        if (!result.getState()) {
//            respCode = BAD_REQUEST;
//        }
//        return SmsJson.build(ResultUtil.genFailedResult(respCode, result.getMsg()));
//    }

//    @ApiOperation(value = "9-02-6 绑定三方账号", hidden = true)
//    @ApiImplicitParam(name = "userId", value = "用户ID")
//    @RequestMapping(value = "api/user/bindingAccount", method = RequestMethod.POST)
//    @Deprecated
//    public Json<UserInfoDTO> binding(WechatBindParam wechatBindParam, Long userId) {
//        LoginInfo loginInfo = ParamAdapter.transformWechatBindToLoginInfo(wechatBindParam);
//        return this.userRegistrationService.binding(loginInfo, userId);
//    }
}
