package com.bxm.localnews.user.controller;

import java.util.List;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.BountyDTO;
import com.bxm.localnews.user.dto.InviteRecordDTO;
import com.bxm.localnews.user.dto.UserPayPromoteDTO;
import com.bxm.localnews.user.service.InviteRecordService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/3/4 14:54
 * @desc
 */
@Api(tags = "9-08 用户邀请关系和对应的赏金相关API", description = "用户建立邀请关系、获取对应的赏金相关信息")
@RestController
@RequestMapping("api/user/invite/record")
public class InviteRecordController {

    @Resource
    private InviteRecordService inviteRecordService;

    @ApiOperation(value = "9-08-1 获取未到账金额详情", notes = "用户的邀请关系赏金列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping()
    public Json<BountyDTO> getUserInviteRecord(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessResult(this.inviteRecordService.getUserBountyInfo(userId));
    }

    @ApiOperation(value = "9-08-2 获取用户已获得赏金信息", notes = "用户的可提现的赏金列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("withdraw")
    public Json<List<InviteRecordDTO>> getUserInviteRecordByWithDrawCash(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value = "9-08-3 创建用户邀请关系", notes = "进入对应绑定关系页面创建邀请关系")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "invitedUserId", value = "受邀用户id"),
            @ApiImplicitParam(name = "type", value = "邀请途径，NEWS 新闻，ACTIVITY 活动，MERCHANT 商户，APPLET 小程序，VIP VIP页面")
    })
    @PostMapping("createUserInvite")
    public Json<Long> createUserInvite(@RequestParam("userId") Long userId,
                                       @RequestParam("invitedUserId") Long invitedUserId,
                                       @RequestParam("type") String type) {
        return ResultUtil.genSuccessResult(this.inviteRecordService.addInviteRecord(userId, invitedUserId, type));
    }

    @ApiOperation(value = "9-08-4 推广赚钱信息", notes = " 推广赚钱信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/promote")
    public Json<UserPayPromoteDTO> userPayPromote(@RequestParam("userId") Long userId) {
        return ResultUtil.genSuccessResult(this.inviteRecordService.getUserPayPromote(userId));
    }

    @ApiOperation(value = "9-08-5 推广赚钱面对面邀请", notes = "用户面对面邀请  授权登陆后获取的数据建立临时用户")
    @PostMapping("/face")
    public Json userFaceInvite() {
        return ResultUtil.genSuccessMsg();
    }

}
