package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.auth.UserAuthCodeService;
import com.bxm.localnews.user.dto.auth.UserAuthCodeDto;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "9-16 用户权限相关API", description = "用户权限控制，包括获取权限信息、新增权限信息")
@RestController
@RequestMapping("{version}/user/auth/security")
public class UserAuthCodeController {
    private UserAuthCodeService userAuthCodeService;

    @Autowired
    public UserAuthCodeController(UserAuthCodeService userAuthCodeService) {
        this.userAuthCodeService = userAuthCodeService;
    }

    @ApiOperation(value = "9-16-1 [v1]获取用户当前拥有的权限信息")
    @ApiImplicitParam(name = "userId", value = "当前用户ID")
    @GetMapping("get")
    @ApiVersion(1)
    public Json<UserAuthCodeDto> get(@RequestParam("userId") Long userId) {
        UserAuthCodeDto userAuthInfo = UserAuthCodeDto.builder()
                .authResources(userAuthCodeService.getAuthResources(userId))
                .combineAuthCode(userAuthCodeService.getAuthCombineCode(userId))
                .build();

        return Json.ok(userAuthInfo);
    }

}
