package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserPersonalInfoDTO;
import com.bxm.localnews.user.param.*;
import com.bxm.localnews.user.service.UserPersonalInfoService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;

@Api(tags = "9-15 用户个人资料相关API")
@RestController
@RequestMapping("{version}/user/personal-info")
public class UserPersonalInfoController {

    @Autowired
    private UserPersonalInfoService userPersonalInfoService;

    @ApiOperation(value = "9-15-01 【v1】更新用户信息【头像】", notes = "支持更换头像")
    @PostMapping(value = "/head-img")
    @ApiVersion(1)
    public Json updateHeadImg(@RequestBody @Valid UserHeadImgParam user) {
        Message message = userPersonalInfoService.updateHeadImg(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }

    }

    @ApiOperation(value = "9-15-02 【v1】更新用户信息【昵称】", notes = "支持更换昵称")
    @PostMapping(value = "/nickname")
    @ApiVersion(1)
    public Json updateNickname(@RequestBody @Valid UserNicknameParam user) {
        Message message = userPersonalInfoService.updateNickname(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-03 【v1】更新用户信息【生日】", notes = "支持更换生日")
    @PostMapping(value = "/birth")
    @ApiVersion(1)
    public Json updateBirth(@RequestBody @Valid UserBirthParam user) {
        Message message = userPersonalInfoService.updateBirth(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-04 【v1】更新用户信息【家乡】", notes = "支持更换家乡")
    @PostMapping(value = "/hometown")
    @ApiVersion(1)
    public Json updateHometown(@RequestBody @Valid UserHomeTownParam user) {
        Message message = userPersonalInfoService.updateHometown(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-05 【v1】更新用户信息【情感状态】", notes = "支持更换情感状态 0：保密  1：单身  2：恋爱中  3：已婚")
    @PostMapping(value = "/emotion")
    @ApiVersion(1)
    public Json updateEmotion(@RequestBody @Valid UserEmotionParam user) {
        Message message = userPersonalInfoService.updateEmotion(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-06 【v1】更新用户信息【职业】", notes = "支持更换职业")
    @PostMapping(value = "/job")
    @ApiVersion(1)
    public Json updateJob(@RequestBody @Valid UserJobParam user) {
        Message message = userPersonalInfoService.updateJob(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-07 【v1】更新用户信息【个人简介】", notes = "支持更换个人简介")
    @PostMapping(value = "/introduction")
    @ApiVersion(1)
    public Json updateIntroduction(@RequestBody @Valid UserIntroductionParam user) {
        Message message = userPersonalInfoService.updatePersonalProfile(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-08 【v1】更新用户信息【手机】", notes = "支持更换手机")
    @PostMapping(value = "/phone")
    @ApiVersion(1)
    public Json updatePhone(@RequestBody @Valid UserPhoneParam user, HttpServletRequest request) throws BindException {
        user.setIp(WebUtils.getIpAddr(request));
        Message message = userPersonalInfoService.updateUserPhone(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult(message.getParam("phone"));
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-09 【v1】更新用户信息【性别】", notes = "支持更换性别")
    @PostMapping(value = "/sex")
    @ApiVersion(1)
    public Json updateSex(@RequestBody @Valid UserSexParam user) {
        Message message = userPersonalInfoService.updateUserSex(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }else{
            return ResultUtil.genFailedResult(message.getLastMessage());
        }
    }

    @ApiOperation(value = "9-15-10 【v1】得到个人资料页面的用户信息", notes = "包含 头像、昵称、性别、生日、地址、兴趣标签等，原来的接口乱七八糟，不用了")
    @GetMapping(value = "/{userId}")
    @ApiVersion(1)
    public Json<UserPersonalInfoDTO> getPersonalInfo(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult(userPersonalInfoService.getUserPersonalInfo(userId));

    }
    @ApiOperation(value = "9-15-11 【v1】用户完善资料弹窗", notes = "用户资料完善弹窗")
    @GetMapping(value = "/pop/{userId}")
    @ApiVersion(1)
    public Json<Boolean> getCompleteInformationWindow(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult(userPersonalInfoService.getCompleteInformationWindow(userId));

    }

}
