package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.param.UserLocationParam;
import com.bxm.localnews.user.service.UserInternalService;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 用户位置信息
 * @author donghy
 */
@Api(tags = "9-17 用户位置信息")
@RestController
@RequestMapping("{version}/user/position")
public class UserPositionController {

    @Resource
    private UserInternalService userInternalService;

    @ApiOperation(value = "9-17-01 上报用户位置信息", notes = "上报用户位置信息与用户登录信息-用户的经纬度以及用户登录app的活跃信息")
    @PostMapping(value = "")
    @ApiVersion(1)
    public Json<Boolean> getUserLocation(@RequestBody UserLocationParam userLocationParam) {
        return ResultUtil.genSuccessResult(userInternalService.postUserPositionAndLoginInfo(userLocationParam));
    }
}
