package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserTagDTO;
import com.bxm.localnews.user.param.CustomTagParam;
import com.bxm.localnews.user.param.UserTagParam;
import com.bxm.localnews.user.service.UserPersonalInfoService;
import com.bxm.localnews.user.service.UserTagService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(tags = "9-04 用户兴趣爱好标签相关API")
@RequestMapping("{version}/user")
@RestController
public class UserTagController extends BaseController {

    @Autowired
    private UserTagService userTagService;

    @Autowired
    private UserPersonalInfoService userPersonalInfoService;

    @ApiOperation(value = "9-04-01 [v1]选中并保存更新用户兴趣标签", notes = "修改用户兴趣", httpMethod = "POST")
    @PostMapping("/tag")
    @ApiVersion(1)
    public Json saveUserTag(@RequestBody @Valid UserTagParam usertagParam) throws BindException {
        return ResultUtil.genSuccessResult(userPersonalInfoService.updateUserTag(usertagParam));
    }

    @ApiOperation(value = "9-04-02 [v1]显示用户兴趣爱好标签列表，分选中与不选中", httpMethod = "GET")
    @GetMapping("/tag/list/{userId}")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    @ApiVersion(1)
    public Json<List<UserTagDTO>> listUserTag(@PathVariable Long userId) throws BindException {
        direct().prop("userId", userId).notBlank("用户id不能为空");
        return ResultUtil.genSuccessResult(userTagService.listUserTag(userId));
    }

    @ApiOperation(value = "9-04-03 [v1]添加用户自定义标签", httpMethod = "POST")
    @PostMapping("/custom-tag")
    @ApiVersion(1)
    public Json<UserTagDTO> saveTag(@RequestBody @Valid CustomTagParam customTagParam) throws BindException {
        Message message = userPersonalInfoService.saveCustomTag(customTagParam);

        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult(message.getParam("tag"));
        } else {
            return ResultUtil.genFailedResult(message.getLastMessage());
        }

    }
}
