package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.WithdrawDTO;

import com.bxm.localnews.user.service.UserAccountService;
import com.bxm.localnews.user.service.UserWithdrawService;
import com.bxm.localnews.user.vo.UserAccount;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/3/4 11:43
 * @desc
 */
@Api(tags = "9-05 用户提现相关API", description = "提现配置信息和用户提现")
@RestController
@RequestMapping("api/user/withdraw")
public class UserWithdrawController {

    @Resource
    private UserAccountService userAccountService;

    @Resource
    private UserWithdrawService userWithdrawService;

    @ApiOperation(value = "9-05-1 获取用户可提现的配置信息列表", notes = "提现配置信息列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("/list")
    public Json<WithdrawDTO> getWithDrawList(@RequestParam("userId") Long userId) {
        UserAccount userAccount = userAccountService.getUserAccountDetail(userId);
        return ResultUtil.genSuccessResult(userWithdrawService.getWithDrawList(
                userId, userAccount.getDrawablelCash(), userAccount.getWithdrawalCash()));
    }

//    @ApiOperation(value = "9-05-2 用户发起提现", notes = "用户账户余额提现", hidden = true)
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "userId", value = "用户id"),
//            @ApiImplicitParam(name = "amount", value = "提现金额")
//    })
//    @PostMapping("")
//    public Json<BigDecimal> userWithDraw(@RequestParam("userId") Long userId, @RequestParam("amount") BigDecimal amount) {
//        return ResultUtil.genSuccessResult(userWithdrawService.userWithdraw(userId, amount));
//    }

    @ApiOperation(value = "9-05-3 是否可以提现", notes = " 是否可以提现")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id")
    })
    @GetMapping("enable")
    public Json<Boolean> enable() {
        return ResultUtil.genSuccessMsg();
    }

}
