package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserVisitDTO;
import com.bxm.localnews.user.param.UserVisitParam;
import com.bxm.localnews.user.service.UserVisitService;
import com.bxm.newidea.component.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "9-12 访客相关API", description = "用户访客相关")
@RestController
@RequestMapping("api/user/visitor")
public class VisitorController extends BaseController {

    @Autowired
    private UserVisitService userVisitService;

    @ApiOperation(value = "9-12-1 用户访问列表", notes = "按日期分页，例如pageSize传3，则每次给3个日期的访客列表，数量不定")
    @GetMapping(value = "list")
    public Json<List<UserVisitDTO>> listVisitor(UserVisitParam userVisitParam) {
        if (null == userVisitParam.getUserId()) {
            return ResultUtil.genFailedResult("用户id不能为空");
        }
        return ResultUtil.genSuccessResult(userVisitService.listUserVisit(userVisitParam));
    }

    @ApiOperation(value = "9-12-2 批量虚拟用户访问，运营专用，请勿调用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "num", value = "数量")
    })
    @PostMapping(value = "public/virtualVisit")
    public Json virtualVisit(@RequestParam(name = "userId") Long userId,
                             @RequestParam(name = "num") Integer num) {
        userVisitService.virtualVisit(userId, num);
        return ResultUtil.genSuccessResult();
    }
}
