/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.CustomerHomePageDTO;
import com.bxm.localnews.user.dto.OnselfHomePageDTO;
import com.bxm.localnews.user.service.HomePageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-10 \u7528\u6237\u4e2a\u4eba\u4e3b\u9875\u76f8\u5173API"}, description="\u7528\u6237\u4e2a\u4eba\u4e3b\u9875\u76f8\u5173\u4fe1\u606f")
@RestController
@RequestMapping(value={"api/user/homePage"})
public class HomePageController {
    private final HomePageService homePageService;

    @ApiOperation(value="9-10-01 \u4e3b\u6001\u7528\u6237\u8bbf\u95ee\u4e3b\u9875", notes="\u4e3b\u6001\u7528\u6237\u8bbf\u95ee\u4e3b\u9875", httpMethod="GET")
    @GetMapping(value={"/oneself"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    public Json<OnselfHomePageDTO> getHomePageByUserId(@RequestParam Long userId) {
        return ResultUtil.genSuccessResult((Object)this.homePageService.getOnselfHomePage(userId));
    }

    @ApiOperation(value="9-10-02 \u5ba2\u6001\u7528\u6237\u8bbf\u95ee\u4e3b\u9875", notes="\u5ba2\u6001\u7528\u6237\u8bbf\u95ee\u4e3b\u9875", httpMethod="GET")
    @GetMapping(value={"/customer"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="targetUserId", value="\u8bbf\u95ee\u7528\u6237id", required=true)})
    public Json<CustomerHomePageDTO> getHomePageByCustomer(Long userId, Long targetUserId) {
        return ResultUtil.genSuccessResult((Object)this.homePageService.getCustomerHomePage(targetUserId, userId));
    }

    @Autowired
    public HomePageController(HomePageService homePageService) {
        this.homePageService = homePageService;
    }
}

