/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserPersonalInfoDTO;
import com.bxm.localnews.user.param.UserBirthParam;
import com.bxm.localnews.user.param.UserEmotionParam;
import com.bxm.localnews.user.param.UserHeadImgParam;
import com.bxm.localnews.user.param.UserHomeTownParam;
import com.bxm.localnews.user.param.UserIntroductionParam;
import com.bxm.localnews.user.param.UserJobParam;
import com.bxm.localnews.user.param.UserNicknameParam;
import com.bxm.localnews.user.param.UserPhoneParam;
import com.bxm.localnews.user.param.UserSexParam;
import com.bxm.localnews.user.service.UserPersonalInfoService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-15 \u7528\u6237\u4e2a\u4eba\u8d44\u6599\u76f8\u5173API"})
@RestController
@RequestMapping(value={"{version}/user/personal-info"})
public class UserPersonalInfoController {
    @Autowired
    private UserPersonalInfoService userPersonalInfoService;

    @ApiOperation(value="9-15-01 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u5934\u50cf\u3011", notes="\u652f\u6301\u66f4\u6362\u5934\u50cf")
    @PostMapping(value={"/head-img"})
    @ApiVersion(value=1)
    public Json updateHeadImg(@RequestBody @Valid UserHeadImgParam user) {
        Message message = this.userPersonalInfoService.updateHeadImg(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-02 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u6635\u79f0\u3011", notes="\u652f\u6301\u66f4\u6362\u6635\u79f0")
    @PostMapping(value={"/nickname"})
    @ApiVersion(value=1)
    public Json updateNickname(@RequestBody @Valid UserNicknameParam user) {
        Message message = this.userPersonalInfoService.updateNickname(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-03 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u751f\u65e5\u3011", notes="\u652f\u6301\u66f4\u6362\u751f\u65e5")
    @PostMapping(value={"/birth"})
    @ApiVersion(value=1)
    public Json updateBirth(@RequestBody @Valid UserBirthParam user) {
        Message message = this.userPersonalInfoService.updateBirth(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-04 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u5bb6\u4e61\u3011", notes="\u652f\u6301\u66f4\u6362\u5bb6\u4e61")
    @PostMapping(value={"/hometown"})
    @ApiVersion(value=1)
    public Json updateHometown(@RequestBody @Valid UserHomeTownParam user) {
        Message message = this.userPersonalInfoService.updateHometown(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-05 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u60c5\u611f\u72b6\u6001\u3011", notes="\u652f\u6301\u66f4\u6362\u60c5\u611f\u72b6\u6001 0\uff1a\u4fdd\u5bc6  1\uff1a\u5355\u8eab  2\uff1a\u604b\u7231\u4e2d  3\uff1a\u5df2\u5a5a")
    @PostMapping(value={"/emotion"})
    @ApiVersion(value=1)
    public Json updateEmotion(@RequestBody @Valid UserEmotionParam user) {
        Message message = this.userPersonalInfoService.updateEmotion(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-06 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u804c\u4e1a\u3011", notes="\u652f\u6301\u66f4\u6362\u804c\u4e1a")
    @PostMapping(value={"/job"})
    @ApiVersion(value=1)
    public Json updateJob(@RequestBody @Valid UserJobParam user) {
        Message message = this.userPersonalInfoService.updateJob(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-07 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u4e2a\u4eba\u7b80\u4ecb\u3011", notes="\u652f\u6301\u66f4\u6362\u4e2a\u4eba\u7b80\u4ecb")
    @PostMapping(value={"/introduction"})
    @ApiVersion(value=1)
    public Json updateIntroduction(@RequestBody @Valid UserIntroductionParam user) {
        Message message = this.userPersonalInfoService.updatePersonalProfile(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-08 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u624b\u673a\u3011", notes="\u652f\u6301\u66f4\u6362\u624b\u673a")
    @PostMapping(value={"/phone"})
    @ApiVersion(value=1)
    public Json updatePhone(@RequestBody @Valid UserPhoneParam user, HttpServletRequest request) throws BindException {
        user.setIp(WebUtils.getIpAddr((HttpServletRequest)request));
        Message message = this.userPersonalInfoService.updateUserPhone(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult((Object)message.getParam("phone"));
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-09 \u3010v1\u3011\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u3010\u6027\u522b\u3011", notes="\u652f\u6301\u66f4\u6362\u6027\u522b")
    @PostMapping(value={"/sex"})
    @ApiVersion(value=1)
    public Json updateSex(@RequestBody @Valid UserSexParam user) {
        Message message = this.userPersonalInfoService.updateUserSex(user);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-15-10 \u3010v1\u3011\u5f97\u5230\u4e2a\u4eba\u8d44\u6599\u9875\u9762\u7684\u7528\u6237\u4fe1\u606f", notes="\u5305\u542b \u5934\u50cf\u3001\u6635\u79f0\u3001\u6027\u522b\u3001\u751f\u65e5\u3001\u5730\u5740\u3001\u5174\u8da3\u6807\u7b7e\u7b49\uff0c\u539f\u6765\u7684\u63a5\u53e3\u4e71\u4e03\u516b\u7cdf\uff0c\u4e0d\u7528\u4e86")
    @GetMapping(value={"/{userId}"})
    @ApiVersion(value=1)
    public Json<UserPersonalInfoDTO> getPersonalInfo(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userPersonalInfoService.getUserPersonalInfo(userId));
    }

    @ApiOperation(value="9-15-11 \u3010v1\u3011\u7528\u6237\u5b8c\u5584\u8d44\u6599\u5f39\u7a97", notes="\u7528\u6237\u8d44\u6599\u5b8c\u5584\u5f39\u7a97")
    @GetMapping(value={"/pop/{userId}"})
    @ApiVersion(value=1)
    public Json<Boolean> getCompleteInformationWindow(@PathVariable Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userPersonalInfoService.getCompleteInformationWindow(userId));
    }
}

