/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserTagDTO;
import com.bxm.localnews.user.param.CustomTagParam;
import com.bxm.localnews.user.param.UserTagParam;
import com.bxm.localnews.user.service.UserPersonalInfoService;
import com.bxm.localnews.user.service.UserTagService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-04 \u7528\u6237\u5174\u8da3\u7231\u597d\u6807\u7b7e\u76f8\u5173API"})
@RequestMapping(value={"{version}/user"})
@RestController
public class UserTagController
extends BaseController {
    @Autowired
    private UserTagService userTagService;
    @Autowired
    private UserPersonalInfoService userPersonalInfoService;

    @ApiOperation(value="9-04-01 [v1]\u9009\u4e2d\u5e76\u4fdd\u5b58\u66f4\u65b0\u7528\u6237\u5174\u8da3\u6807\u7b7e", notes="\u4fee\u6539\u7528\u6237\u5174\u8da3", httpMethod="POST")
    @PostMapping(value={"/tag"})
    @ApiVersion(value=1)
    public Json saveUserTag(@RequestBody @Valid UserTagParam usertagParam) throws BindException {
        return ResultUtil.genSuccessResult((Object)this.userPersonalInfoService.updateUserTag(usertagParam));
    }

    @ApiOperation(value="9-04-02 [v1]\u663e\u793a\u7528\u6237\u5174\u8da3\u7231\u597d\u6807\u7b7e\u5217\u8868\uff0c\u5206\u9009\u4e2d\u4e0e\u4e0d\u9009\u4e2d", httpMethod="GET")
    @GetMapping(value={"/tag/list/{userId}"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @ApiVersion(value=1)
    public Json<List<UserTagDTO>> listUserTag(@PathVariable Long userId) throws BindException {
        this.direct().prop("userId", (Object)userId).notBlank("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        return ResultUtil.genSuccessResult((Object)this.userTagService.listUserTag(userId));
    }

    @ApiOperation(value="9-04-03 [v1]\u6dfb\u52a0\u7528\u6237\u81ea\u5b9a\u4e49\u6807\u7b7e", httpMethod="POST")
    @PostMapping(value={"/custom-tag"})
    @ApiVersion(value=1)
    public Json<UserTagDTO> saveTag(@RequestBody @Valid CustomTagParam customTagParam) throws BindException {
        Message message = this.userPersonalInfoService.saveCustomTag(customTagParam);
        if (message.isSuccess()) {
            return ResultUtil.genSuccessResult((Object)message.getParam("tag"));
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }
}

