/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.CashFlowService;
import com.bxm.localnews.user.account.UserAmountService;
import com.bxm.localnews.user.dto.AccountCashFlowDTO;
import com.bxm.localnews.user.dto.AccountIncomeDTO;
import com.bxm.localnews.user.dto.CashFlowDTO;
import com.bxm.localnews.user.param.AccountCashFlowPageParam;
import com.bxm.localnews.user.param.CashFlowParam;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-07 \u7528\u6237\u73b0\u91d1\u6d41\u6c34\u76f8\u5173API"}, description="\u7528\u6237\u73b0\u91d1\u6d41\u6c34\u76f8\u5173\u4fe1\u606f")
@RestController
public class CashFlowController {
    private final CashFlowService cashFlowService;
    private final UserAmountService userAmountService;

    @Autowired
    public CashFlowController(CashFlowService cashFlowService, UserAmountService userAmountService) {
        this.cashFlowService = cashFlowService;
        this.userAmountService = userAmountService;
    }

    @ApiOperation(value="9-07-1 \u83b7\u53d6\u7528\u6237\u6d41\u6c34\u4fe1\u606f", notes="\u7528\u6237\u7684\u6d41\u6c34\u5217\u8868")
    @GetMapping(value={"api/user/cash/flow"})
    public Json<List<CashFlowDTO>> getUserCashFlow(CashFlowParam cashFlowParam) {
        return ResultUtil.genSuccessResult((Object)this.cashFlowService.getUserAllCashFlow(cashFlowParam));
    }

    @ApiOperation(value="9-07-3 [v1]\u5206\u9875\u83b7\u53d6\u73b0\u91d1\u6536\u76ca\u6d41\u6c34", notes="\u5206\u9875\u67e5\u8be2\u7528\u6237\u73b0\u91d1\u6536\u76ca\u6d41\u6c34")
    @GetMapping(value={"{version}/user/account/cash/flow"})
    @ApiVersion(value=1)
    public ResponseJson<PageWarper<AccountCashFlowDTO>> getUserCashFlow(AccountCashFlowPageParam param) {
        return ResponseJson.ok((Object)this.cashFlowService.queryCashByPage(param));
    }

    @ApiOperation(value="9-07-4 [v1]\u83b7\u53d6\u7528\u6237\u73b0\u91d1\u6536\u76ca\u6570\u636e", notes="\u7528\u6237\u7528\u6237\u76f8\u5173\u7684\u73b0\u91d1\u6536\u76ca\u4e0e\u914d\u7f6e\u7684\u6d41\u6c34\u5206\u7c7b\u5217\u8868")
    @GetMapping(value={"{version}/user/account/cash/income"})
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @ApiVersion(value=1)
    public ResponseJson<AccountIncomeDTO> getIncome(Long userId) {
        return ResponseJson.ok((Object)this.userAmountService.getCashIncome(userId));
    }
}

