/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.login.LoginService;
import com.bxm.localnews.user.login.adapter.ParamAdapter;
import com.bxm.localnews.user.param.RegisterParam;
import com.bxm.localnews.user.vo.LoginInfo;
import com.bxm.localnews.user.vo.LoginMeta;
import com.bxm.localnews.user.vo.LoginParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-01 \u7528\u6237\u767b\u5f55\u76f8\u5173API"}, description="\u7528\u6237\u767b\u5f55\u548c\u6ce8\u518c")
@RestController
@RequestMapping(value={"api/login"})
public class LoginController {
    private static final Logger logger = LoggerFactory.getLogger(LoginController.class);
    @Resource
    private LoginService loginService;
    @Resource
    private RedisSetAdapter redisSetAdapter;

    @ApiOperation(value="9-01-1 \u7528\u6237\u767b\u5f55", notes="\u652f\u6301[\u624b\u673a\u53f7\u5bc6\u7801\u767b\u5f55][\u7b2c\u4e09\u65b9\u767b\u5f55][h5\u5fae\u4fe1\u6388\u6743\u767b\u5f55]")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5", allowableValues="1,2,3"), @ApiImplicitParam(name="chnl", value="\u6e20\u9053\u4fe1\u606f \u5177\u4f53\u67e5\u770bC_CHANNEL\u8868\u6216\u627e[\u8d75\u4e9a\u4e1c]")})
    @RequestMapping(value={"toLogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public Json<LoginMeta> login(LoginParam loginParam, BasicParam basicParam, HttpServletRequest request) {
        logger.warn("\u767b\u5f55\u53c2\u6570:{}\uff0c\u57fa\u7840\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)loginParam), (Object)JSONObject.toJSONString((Object)basicParam));
        LoginInfo loginInfo = ParamAdapter.transformLoginParamToLoginInfo((LoginParam)loginParam, (BasicParam)basicParam);
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        loginInfo.setRegIp(ip);
        loginInfo.setLastLoginIp(ip);
        Message message = this.loginService.doLogin(loginInfo, basicParam);
        if (message.isSuccess()) {
            LoginMeta loginMeta = (LoginMeta)message.getParam("meta");
            KeyGenerator k = RedisConfig.IS_NEED_RE_LOGIN.copy();
            if ("3.1.2".equals(basicParam.getCurVer())) {
                logger.info("3.1.2\u7684\u7528\u6237\u9700\u8981\u8fdb\u884c\u8bb0\u5f55");
                if (!this.redisSetAdapter.exists(k, (Object)loginMeta.getUser().getId()).booleanValue()) {
                    this.redisSetAdapter.add(k, new Object[]{loginMeta.getUser().getId()});
                }
            }
            return ResultUtil.genSuccessResult((Object)message.getParam("meta"));
        }
        return ResultUtil.genFailedResult((String)message.getLastMessage());
    }

    @ApiOperation(value="9-01-2 \u7528\u6237\u6ce8\u518c", notes="\u652f\u6301[\u7aef\u5185\u624b\u673a\u53f7\u6ce8\u518c][\u7aef\u5185\u7b2c\u4e09\u65b9\u7ed1\u5b9a\u6ce8\u518c][h5\u7ad9\u5916\u5fae\u4fe1\u7b2c\u4e09\u65b9\u6388\u6743\u6ce8\u518c]")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platform", value="\u5e73\u53f0\u4fe1\u606f 1\uff1a\u5b89\u5353 2\uff1aIOS 3\uff1aH5", allowableValues="1,2,3"), @ApiImplicitParam(name="chnl", value="\u6e20\u9053\u4fe1\u606f \u5177\u4f53\u67e5\u770bC_CHANNEL\u8868\u6216\u627e[\u8d75\u4e9a\u4e1c]")})
    @RequestMapping(value={"registerBindingPhone"}, method={RequestMethod.POST})
    public Json<LoginMeta> registerAndBindingPhone(RegisterParam registerParam, BasicParam basicParam, Long userId, HttpServletRequest request) {
        logger.warn("\u6ce8\u518c\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)registerParam));
        if (1 == registerParam.getType()) {
            logger.warn("\u8be5\u7528\u6237\u4f7f\u7528\u624b\u673a\u6ce8\u518c,\u8bf7\u6ce8\u610f,\u7528\u6237\u4fe1\u606f:{}", JSON.toJSON((Object)registerParam));
        }
        LoginInfo loginInfo = ParamAdapter.transformRegisterToLoginInfo((RegisterParam)registerParam, (BasicParam)basicParam);
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        loginInfo.setRegIp(ip);
        loginInfo.setLastLoginIp(ip);
        return this.loginService.registerAndBindingPhone(loginInfo, userId, basicParam);
    }
}

