/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.account.AccountService;
import com.bxm.localnews.user.account.UserAccountService;
import com.bxm.localnews.user.dto.UserAccountDTO;
import com.bxm.localnews.user.dto.UserAccountDayCashDTO;
import com.bxm.localnews.user.dto.UserCashGoldDTO;
import com.bxm.localnews.user.param.TransformParam;
import com.bxm.localnews.user.vo.UserCashInfoVo;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-06 \u7528\u6237\u8d26\u6237\u76f8\u5173API"}, description="\u7528\u6237\u8d26\u6237\u91d1\u989d\u4fe1\u606f\u3001\u91d1\u5e01\u4fe1\u606f\u3001\u660e\u7ec6\u7b49")
@RestController
public class UserAccountController {
    @Resource
    private UserAccountService userAccountService;
    @Resource
    private AccountService accountService;

    @ApiOperation(value="9-06-1 \u83b7\u53d6\u6211\u7684\u8d26\u6237\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5bf9\u5e94\u7684\u91d1\u5e01\u4f59\u989d\u548c\u73b0\u91d1\u4f59\u989d\u3001\u91d1\u5e01\u603b\u6536\u5165\u3001\u73b0\u91d1\u603b\u6536\u5165")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id")})
    @GetMapping(value={"/api/user/account"})
    public Json<UserAccountDTO> getUserAccount(@RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userAccountService.getUserAccountAndEnableWithdraw(userId));
    }

    @ApiOperation(value="9-06-2 \u83b7\u53d6\u7528\u6237\u8d26\u6237\u4fe1\u606f\u548c\u6700\u8fd17\u5929\u7684\u73b0\u91d1\u6536\u5165", httpMethod="GET", notes="\u7528\u6237\u8d26\u6237\u4fe1\u606f\u548c\u7edf\u8ba1\u7528\u6237\u5bf9\u5e94\u6bcf\u5929\u7684\u6536\u5165\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="areaCode", value="\u533a\u57dfCode")})
    @GetMapping(value={"/api/user/account/cash"})
    public Json<UserAccountDayCashDTO> getUserCashByDay(@RequestParam(value="userId") Long userId, @RequestParam(value="areaCode") String areaCode) {
        return ResultUtil.genSuccessResult((Object)this.userAccountService.getUserAccountAndDetail(userId, areaCode));
    }

    @ApiOperation(value="9-06-3 \u83b7\u53d6\u4e2a\u4eba\u4e2d\u5fc3\u94b1\u5305\u548c\u91d1\u5e01\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5bf9\u5e94\u7684\u91d1\u5e01\u4f59\u989d\u548c\u73b0\u91d1\u4f59\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id")})
    @GetMapping(value={"/api/user/account/my"})
    public Json<UserCashGoldDTO> getUserCashGold(@RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userAccountService.getUserCashGold(userId));
    }

    @ApiOperation(value="9-06-4 \u7528\u6237\u63d0\u73b0\u5f39\u7a97\u4e0a\u62a5", httpMethod="POST", notes="\u7528\u6237\u5df2\u7ecf\u51fa\u73b0\u5f39\u7a97\u9700\u8981\u4e0a\u62a5\u7ed9\u670d\u52a1\u7aef")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id")})
    @PostMapping(value={"/api/user/account/pop/withdraw"})
    public Json userWithdrawPop(@RequestParam(value="userId") Long userId) {
        this.userAccountService.userWithdrawPop(userId);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="9-06-5 \u7528\u6237\u8d26\u6237\u79ef\u5206\u5151\u6362", httpMethod="POST", notes="\u7528\u6237\u8d26\u6237\u53ef\u7528\u79ef\u5206\u63d0\u73b0\u5230\u5fae\u4fe1;\u8fd4\u56de\u503c\uff1a\u5927\u4e8e0\u5219\u63d0\u73b0\u6210\u529f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="openId", value="\u7528\u6237openId"), @ApiImplicitParam(name="amount", value="\u63d0\u73b0\u91d1\u989d")})
    @PostMapping(value={"/api/user/account/gold/withdraw"})
    public Json userGoldWithdraw(@RequestParam(value="userId") Long userId, @RequestParam(value="openId") String openId, @RequestParam(value="amount") BigDecimal amount, BasicParam basicParam, HttpServletRequest request) {
        return this.userAccountService.userGoldWithdraw(userId, openId, amount, basicParam.getDevcId(), WebUtils.getIpAddr((HttpServletRequest)request));
    }

    @ApiOperation(value="9-06-6 \u83b7\u53d6\u7528\u6237\u53ca\u9080\u8bf7\u4eba\u5df2\u83b7\u5f97\u91d1\u989d\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true)})
    @GetMapping(value={"/api/user/account/public/getUserCashInfo"})
    public Json<UserCashInfoVo> getUserCashInfo(@RequestParam(name="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.userAccountService.getUserCashInfo(userId));
    }

    @ApiOperation(value="9-06-7 [v1] \u83b7\u53d6\u7528\u6237\u5c0f\u7ea2\u82b1\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u5c0f\u7ea2\u82b1\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @GetMapping(value={"{version}/user/account/balance"})
    @ApiVersion(value=1)
    public Json<BigDecimal> selectUsableGoldByUserId(@RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult((Object)this.accountService.selectUsableGoldByUserId(userId));
    }

    @ApiOperation(value="9-06-8 [v1] \u7528\u6237\u8d60\u9001\u5c0f\u7ea2\u5305\u7ed9\u76ee\u6807\u804a\u5929\u7528\u6237")
    @PostMapping(value={"{version}/user/account/transform"})
    @ApiVersion(value=1)
    public Json<BigDecimal> presentFlower(@RequestBody TransformParam param) {
        return ResultUtil.genSuccessResult((Object)this.userAccountService.presentFlower(param));
    }
}

