/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.controller;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.dto.h5.ClientVersionDto;
import com.bxm.localnews.user.dto.h5.PublicUserInfoDto;
import com.bxm.localnews.user.login.UserService;
import com.bxm.localnews.user.param.UserClipboardParam;
import com.bxm.localnews.user.support.UserEquipmentService;
import com.bxm.newidea.component.annotations.ApiVersion;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"9-18 \u7528\u6237\u5bf9\u5916\u7684\u516c\u5f00\u63a5\u53e3"})
@RestController
@RequestMapping(value={"{version}/user/public"})
public class UserPublicController {
    private static final Logger log = LoggerFactory.getLogger(UserPublicController.class);
    private final UserService userService;
    private UserEquipmentService userEquipmentService;

    @Autowired
    public UserPublicController(UserService userService, UserEquipmentService userEquipmentService) {
        this.userService = userService;
        this.userEquipmentService = userEquipmentService;
    }

    @ApiOperation(value="9-18-01 [v1]\u83b7\u53d6\u7528\u6237\u516c\u5f00\u4fe1\u606f")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID")
    @ApiVersion(value=1)
    @GetMapping(value={"get"})
    public Json<PublicUserInfoDto> get(Long userId) {
        PublicUserInfoDto publicUser = PublicUserInfoDto.builder().userId(userId).build();
        UserInfoDTO userInfo = this.userService.getUserCache(userId);
        if (null != userInfo && null != userInfo.getState() && 1 == userInfo.getState()) {
            publicUser.setRegUser(Boolean.valueOf(true));
        }
        return Json.ok((Object)publicUser);
    }

    @ApiOperation(value="9-18-02 [v1]\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u5ba2\u6237\u7aef\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="targetUserId", value="\u67e5\u8be2\u76ee\u6807\u7528\u6237ID"), @ApiImplicitParam(name="curVer", value="[\u901a\u7528\u53c2\u6570]\u5ba2\u6237\u7aef\u5f53\u524d\u7248\u672c")})
    @ApiVersion(value=1)
    @GetMapping(value={"client/version"})
    public Json<ClientVersionDto> clientVersion(Long targetUserId, String curVer) {
        return Json.ok((Object)this.userEquipmentService.queryClientVersion(targetUserId, curVer));
    }

    @ApiOperation(value="9-18-03 [v1]\u4e0a\u4f20\u7c98\u8d34\u677f\u4fe1\u606f", notes="\u5e94\u7528\u8fdb\u5165\u9996\u9875\u65f6\uff0c\u5c06\u7559\u5b58\u7684\u7c98\u8d34\u677f\u4fe1\u606f\u4e0a\u62a5\u5230\u670d\u52a1\u7aef\u8fdb\u884c\u5f02\u6b65\u5904\u7406\uff0c\u4e0d\u5173\u5fc3\u5177\u4f53\u7684\u8fd4\u56de\u503c")
    @ApiVersion(value=1)
    @PostMapping(value={"clipboard"})
    public ResponseJson<Boolean> clipboardUpload(@RequestBody UserClipboardParam param) {
        return ResponseJson.ok((Object)this.userService.clipboardUpload(param));
    }
}

