package com.bxm.localnews.user.enums;

/**
 * 用户标志位
 *
 * @author Gonzo
 * @date 2020-06-02 14:59
 * @see com.bxm.newidea.component.tools.BitOperatorUtil
 * @since 1.0.0
 */
public enum LocalNewsUserJudgeMarkerEnum {

    /**
     * 已下单
     */
    HAS_ORDERED(1),

    /**
     * 关闭订单隐私
     */
    ORDER_PRIVACY(2),

    /**
     * 3.5.0版本以上注册用户
     */
    VER_3_5_0(3),

    /**
     * 3.6.0版本以上注册用户
     */
    VER_3_6_0(4),

    /**
     * 3.7.0版本以上注册用户
     */
    VER_3_7_0(5),

    /**
     * 参加过抽奖活动
     */
    JOINED_LOTTERY(6),

    /**
     * 3.9.0版本以上注册用户
     */
    VER_3_9_0(7),

    /**
     * 老的达人用户：用于从老的邀请关系转过来的那部分用户可以得到收益
     */
    OLD_TALENT_USER(8),

    /**
     * 3.11.0版本以上注册用户
     */
    VER_3_11_0(9);

    int index;

    public int getIndex() {
        return index;
    }

    LocalNewsUserJudgeMarkerEnum(int index) {
        this.index = index;
    }
}
