package com.bxm.localnews.user.event;

import com.bxm.localnews.user.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户最后活跃信息
 *
 * @author liujia
 * @date 2020-07-16 16:00
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class ActiveActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.ACTIVE;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 当前定位位置地区编码
     */
    private String currentAreaCode;

    /**
     * 经度，如果未开启定位，则为空
     */
    private String longitude;

    /**
     * 纬度，如果未开启定位，则为空
     */
    private String latitude;
}
