package com.bxm.localnews.user.event;

import com.bxm.localnews.user.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 用户属性变更事件
 *
 * @author liujia
 * @date 2020-07-16 15:06
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class AttributeActionEvent extends UserActionEvent {

    private final UserActionEnum action = UserActionEnum.ATTRIBUTE;

    /**
     * 出生日期
     */
    private Date birth;

    /**
     * 性别
     */
    private Integer sex;

    /**
     * 家乡地区编码
     */
    private String hometownCode;


    /**
     * 资料完整度
     */
    private Integer infoCompletePercent;

    /**
     * 行业种类
     */
    private Integer jobCategory;
}
