/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author : jieli.xu
 * @date 2020/6/6 17:35
 */
@Data
@ApiModel("vip详情信息")
public class VipInfoDetailDTO {

    @ApiModelProperty("用户UserId")
    private Long userId;

    @ApiModelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty("用户头像")
    private String headImg;

    @ApiModelProperty("用户手机号码，带有掩码")
    private String phone;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty("过期日期")
    private String expiredDate;

    @ApiModelProperty("剩余激活码次数")
    private Integer leftOpenNum;

    @ApiModelProperty("已经激活码次数")
    private Integer activeTimes;

    @ApiModelProperty("卡号")
    private String card;

    @ApiModelProperty("激活码")
    private String activeCode;

    @ApiModelProperty("VIP状态 1:激活 0：已过期 2：待激活")
    private Integer status;

    @ApiModelProperty("成为VIP后节省的金额")
    private BigDecimal rebateAmount;

    @ApiModelProperty("省钱占比，已包含百分号，直接显示即可。请求场景为MAIN才返回")
    private String rebatePercent;

    @ApiModelProperty("当前地区的VIP总人数。请求场景为MAIN才返回")
    private String totalVip;

    @ApiModelProperty("是否有新的节省金额，如果为true需要显示动画")
    private Boolean addRebate;

    @ApiModelProperty("VIP开通方式（0:自费、1:激活）")
    private Integer type;

    @ApiModelProperty("达人等级：0普通用户，1小达人，2中达人，3大达人")
    private Integer talentLevel;
}
