package com.bxm.localnews.user.model;

import com.google.common.collect.Maps;
import lombok.Data;

import java.util.Map;

/**
 * 个人弹窗缓存
 */
@Data
public class PopCache {

    /**
     * 是否可以弹
     */
    private boolean popUp;

    /**
     * 执行过程中的参数map
     */
    private Map<String, Object> paramMap = Maps.newHashMap();

    /**
     * 调用过程中添加参数
     * @param key   参数的键值
     * @param value 键值对应的值
     */
    public PopCache addParam(String key, Object value) {
        this.paramMap.put(key, value);
        return this;
    }

    /**
     * 获取消息传递的参数信息
     * @return 参数MAP
     */
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    /**
     * 获取消息传递的参数信息
     * @return 参数MAP
     */
    public <T> T getParam(String key) {
        return (T) this.paramMap.get(key);
    }
}
