package com.bxm.localnews.user.properties;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author zhaoyadong 2019/3/9 13:41
 * @desc
 */
@Data
@Component
@ConfigurationProperties("common.config")
public class CommonProperties {

    /**
     * 万事通默认图标
     */
    private String appIconUrl;

    /**
     * 应用名称
     */
    private String appName = "本地万事通";

    /**
     * 推广赚钱地址
     */
    private String linkUrl;

    /**
     * H5基地址
     */
    private String h5ServerHost;

    /**
     * 创蓝短信appid与解密密钥的对应关系
     */
    private Map<String, String> chuanglanAppIdDes = Maps.newHashMap();

    /**
     * 创蓝闪验平台与appid
     */
    private Map<Integer, String> chuanglanAppId = Maps.newHashMap();

    /**
     * 创蓝闪验加密私钥
     */
    private String chuanglanPrivateKey;

    /**
     * 模拟用户手机号码
     */
    private String chuanglanMockPhone;
}
