package com.bxm.localnews.user.properties;

import com.alibaba.fastjson.JSONArray;
import com.bxm.localnews.user.model.VipCardInfoDTO;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 自定义类型转换器
 *
 * @author liujia
 * @date 2020/6/2 13:59
 **/
@ConfigurationPropertiesBinding
@Component
public class StringToVipCardConfigConverter implements Converter<String, List<VipCardInfoDTO>> {
    @Override
    public List<VipCardInfoDTO> convert(String source) {
        if (StringUtils.isBlank(source)) {
            return Lists.newArrayList();
        }

        return JSONArray.parseArray(source, VipCardInfoDTO.class);
    }
}
