package com.bxm.localnews.user.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

@Component
@ConfigurationProperties("user.config")
@Data
public class UserProperties {

    /**
     * 微信信息同步超时时间
     */
    private long wechatSyncTimeout;

    /**
     * 金币流水记录开关
     */
    private boolean flowSwitch;

    /**
     * 用户默认头像
     */
    private String defaultHeadImgUrl;

    /**
     * 用户生成token时的appKey
     */
    private String appKey;

    /**
     * 金币兑换率
     */
    private BigDecimal goldRate = BigDecimal.valueOf(1000);

    /**
     * 当天限制提现金额
     */
    private BigDecimal todayLimitBalance = BigDecimal.valueOf(10);

    /**
     * 每笔提现最低金额
     */
    private BigDecimal mixWithdrawBalance = BigDecimal.valueOf(0.3);

    /**
     * 每笔提现最大金额
     */
    private BigDecimal maxWithdrawBalance = BigDecimal.valueOf(10);

    /**
     * 新用户邀请奖励 500朵小红花
     */
    private Integer newUserGold = 500;

    /**
     * 老用户邀请奖励3朵小红花
     */
    private Integer oldUserGold = 3;

    /**
     * 线下推广赏金
     */
    private BigDecimal bountyOffline;

    /**
     * 用户定时统计钉钉群机器人webhook地址
     */
    private String regStatisticsWebhook;

    /**
     * 本地人列表引导完善资料卡片文案
     */
    private String nativeNewbieGuideText = "完善个人信息，让更多人认识你";

    /**
     * 本地人列表引导完善资料个人简介
     */
    private String nativeNewbieGuidePersonalProfile = "未填写个人介绍";

    /**
     * 本地人列表引导完善资料卡片位置
     */
    private Integer nativeNewbieGuidePosition = 2;

    /**
     * 引导完善资料阈值
     */
    private Integer nativeNewbieGuideThreshold = 80;

    /**
     * 个人资料页面小红花提示
     */
    private String infoCompleteTaskText = "首次完成资料赠送30朵小红花";

}
