/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.user.properties;

import com.bxm.localnews.user.model.VipCardInfoDTO;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author : jieli.xu
 * @date 2020/5/20 15:17
 */
@Component
@ConfigurationProperties("user.vip")
@Data
public class UserVipProperties {
    /**
     * VIP会员卡配置信息
     */
    private List<VipCardInfoDTO> cardConfig;

    /**
     * 用户获得的激活码默认可用次数
     */
    private Integer defaultCodeNum = 5;

    /**
     * vip激活码激活默认赠送的时间
     */
    private Integer defaultCodeDay = 365;

    /**
     * 师傅邀请徒弟充值VIP成功奖励的金额，单位元
     */
    private BigDecimal masterReward;

    /**
     * 渠道商的激活码可使用次数
     */
    private Integer channelCodeNum = 1;

}
