package com.bxm.localnews.user.domain;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.user.param.GoldFlowParam;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.GoldFlow;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2019/3/5 20:12
 * @desc
 */
@Mapper
public interface GoldFlowMapper {

    /**
     * 查询流水信息
     *
     * @return
     */
    List<GoldFlow> queryGoldFlows(GoldFlowParam cashFlowParam);

    /**
     * 添加用户流水
     *
     * @param goldFlow
     * @return
     */
    int addGoldFlow(GoldFlow goldFlow);

    /**
     * 更新流水
     *
     * @param goldFlow
     * @return
     */
    int updateGoldFlow(GoldFlow goldFlow);

    /**
     * 获取昨日金币
     *
     * @param userId
     * @return
     */
    BigDecimal getYesterdayGold(Long userId);

    /**
     * 获取金币流水
     *
     * @param userId
     * @return
     */
    List<FlowDetail> listGoldFlow(Long userId);

    /**
     * 根据帖子id获取流水金币数
     *
     * @param postId
     * @param userId
     * @return
     */
    Integer countGoldByPostId(@Param("postId") Long postId, @Param("userId") Long userId);
}
