package com.bxm.localnews.user.domain;

import java.math.BigDecimal;

import com.bxm.localnews.user.vo.UserAccount;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2019/3/5 19:49
 * @desc
 */
@Mapper
public interface UserAccountMapper {

    /**
     * 获取用户账户信息
     *
     * @param userId
     * @return
     */
    UserAccount getUserAccount(@Param("userId") Long userId);

    /**
     * 创建用户账户信息
     *
     * @param userAccount
     * @return
     */
    int addUserAccount(UserAccount userAccount);

    /**
     * 更新用户账户信息
     *
     * @param userAccount
     * @return
     */
    int updateUserAccount(UserAccount userAccount);

    /**
     * 更新临时赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int addUserTempCash(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 更新永久赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int addUserStabilizeCash(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 更新可提现赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int addUserDrawableCash(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 更新已提现赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int addUserWithdrawalCash(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 更新累计赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int addUserTotalCash(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 临时赏金转化为永久赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int tempToStabilize(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 永久赏金转化为可提现赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int stabilizeToDrawable(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 可提现赏金转化为已提现赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int drawableToWithdrawal(@Param("userId") Long userId, @Param("cash") BigDecimal cash);

    /**
     * 临时赏金转化为已提现赏金
     *
     * @param userId
     * @param cash
     * @return
     */
    int tempToDrawable(@Param("userId") Long userId, @Param("cash") BigDecimal cash);


    /**
     * 更新临时金币
     *
     * @param userId
     * @param gold
     * @return
     */
    int addUserTempGold(@Param("userId") Long userId, @Param("gold") Integer gold);


    /**
     * 更新可用金币
     *
     * @param userId
     * @param gold
     * @return
     */
    int addUserUsableGold(@Param("userId") Long userId, @Param("gold") Integer gold);

    /**
     * 更新已消费金币
     * 说明：消费金币增加  可用金币减少
     *
     * @param userId
     * @param gold
     * @return
     */
    int addUserConsumeGold(@Param("userId") Long userId, @Param("gold") Integer gold);

    /**
     * 更新累计金币
     *
     * @param userId
     * @param gold
     * @return
     */
    int addUserTotalGold(@Param("userId") Long userId, @Param("gold") Integer gold);

}
