package com.bxm.localnews.user.param;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.BaseBean;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/3/14 17:16
 * @desc
 */
@ApiModel(description = "流水参数")
public class GoldFlowParam extends BaseBean implements IUserIdSharding {


    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty("日期(yyyy-mm-dd格式)")
    private String date;

    @ApiModelProperty("流水类型 收入：income, 支出：spending")
    private String type;

    @ApiModelProperty(value = "结束时间(yyyy-mm-dd格式)", hidden = true)
    private String endDate;

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}
