package com.bxm.localnews.user.vo;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhaoyadong 2019/4/16 14:35
 * @desc
 */
@ApiModel(description = "设备记录")
@Data
public class UserEquipment {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("设备号")
    private String equipment;

    @ApiModelProperty("状态：0禁用 1启用")
    private Byte status;

    @ApiModelProperty("活动类型： 抽奖：draw")
    private String activityType;

    @ApiModelProperty("是否使用 0：否 1是")
    private Byte receive = 1;

    @ApiModelProperty("创建时间")
    private Date createTime;

    public UserEquipment() {
    }

    public UserEquipment(Long id, String equipment, String activityType) {
        this.id = id;
        this.equipment = equipment;
        this.status = 1;
        this.activityType = activityType;
        this.receive = receive = 1;
        this.createTime = new Date();
    }
}
