package com.bxm.localnews.user.controller;

import java.math.BigDecimal;
import java.util.List;

import com.bxm.localnews.user.service.PayFlowService;
import com.bxm.localnews.user.vo.FlowDetail;
import com.bxm.localnews.user.vo.PayFlow;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/3/1 15:51
 * @desc
 */
@Api(tags = "9-90 [内部接口]用户流水相关接口")
@RequestMapping("facade/user/payflow")
@RestController
@Slf4j
public class PayFlowFacadeController {

    @Autowired
    private PayFlowService payFlowService;

    @ApiOperation(value = "9-90-01 修改用户流水", notes = "修改用户流水", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "gold", value = "金币数量"),
            @ApiImplicitParam(name = "isAttribute", value = "是否是进贡流水")
    })
    @PostMapping("/update")
    public void modifyAccountFlowAndStatByGold(@RequestBody PayFlow payFlow, @RequestParam("gold") BigDecimal gold,
                                               @RequestParam("isAttribute") boolean isAttribute) {
        payFlowService.modifyAccountFlowAndStatByGold(payFlow, gold, isAttribute);
    }

    @ApiOperation(value = "9-90-02 获取用户流水", notes = "获取用户流水", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "rewardTypeGold", value = "金币类型")
    })
    @GetMapping("/detail")
    public ResponseEntity<List<FlowDetail>> listPayFlowToday(@RequestParam("userId") Long userId,
                                                             @RequestParam("rewardTypeGold") byte rewardTypeGold) {
        return ResponseEntity.ok(payFlowService.listPayFlowToday(userId, rewardTypeGold));
    }
}
