package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.service.InviteRecordService;
import com.bxm.localnews.user.vo.InviteRecord;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;

@Api(tags = "9-95 [内部接口]用户邀请关系相关接口")
@RequestMapping("facade/user/invite")
@RestController
@Slf4j
public class InviteRecordFacadeController {

    @Resource
    private InviteRecordService inviteRecordService;

    @ApiOperation(value = "9-95-1 添加邀请关系", httpMethod = "POST", notes = "添加邀请关系并生成失效定时任务")
    @PostMapping("/addInviteRecord")
    public ResponseEntity<Long> addInviteRecord(@RequestParam("userId") Long userId,
                                                @RequestParam("invitedUserId") Long invitedUserId,
                                                @RequestParam("type") String type) {
        return ResponseEntity.ok(this.inviteRecordService.addInviteRecord(userId, invitedUserId, type));
    }

    @ApiOperation(value = "9-95-2 更新邀请关系金额", httpMethod = "POST")
    @PostMapping("/updateInviteCash")
    public ResponseEntity<Long> updateInviteCash(@RequestParam("userId") Long userId,
                                                 @RequestParam("invitedUserId") Long invitedUserId,
                                                 @RequestParam("cash") BigDecimal cash) {
        return ResponseEntity.ok(this.inviteRecordService.updateInviteCash(userId, invitedUserId, cash));
    }

    @ApiOperation(value = "9-95-3 根据邀请人和受邀人获取邀请关系", httpMethod = "GET")
    @GetMapping("/getInviteRecordByInvitedUser")
    public ResponseEntity<InviteRecord> getInviteRecordByInvitedUser(@RequestParam("userId") Long userId,
                                                                     @RequestParam("invitedUserId") Long invitedUserId) {
        return ResponseEntity.ok(this.inviteRecordService.getInviteRecordByInvitedUser(userId, invitedUserId));
    }

    @ApiOperation(value = "9-95-4 根据邀请人和id获取邀请关系", httpMethod = "GET")
    @GetMapping("/getInviteRecordById")
    public ResponseEntity<InviteRecord> getInviteRecordById(@RequestParam("userId") Long userId,
                                                            @RequestParam("id") Long id) {
        return ResponseEntity.ok(this.inviteRecordService.getInviteRecordById(userId, id));
    }
}
