package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.dto.UserRedPacketDTO;
import com.bxm.localnews.user.service.RedPacketService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;


@Api(tags = "9-97 [内部接口]用户红包")
@RestController
@RequestMapping("facade/user/redPacket")
@Slf4j
public class RedPackFacadeController {

    @Resource
    private RedPacketService redPacketService;

    @ApiOperation(value = "9-97-1 获取对应地区是否开启红包", notes = "判断用户是否满足领取新人红包条件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "devcId", value = "设备id"),
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "areaCode", value = "地区编码(12位地区编码)")
    })
    @GetMapping("/enable")
    public ResponseEntity<UserRedPacketDTO> enableRedPacket(@RequestParam("devcId") String devcId,
                                                            @RequestParam("userId") Long userId,
                                                            @RequestParam("areaCode") String areaCode) {
        return ResponseEntity.ok(this.redPacketService.enableRedPacket(devcId, userId, areaCode));
    }
}
