package com.bxm.localnews.user.controller;

import com.bxm.localnews.user.enums.AppConst;
import com.bxm.localnews.user.service.UserAuthService;
import com.bxm.localnews.user.vo.UserAuth;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/3/1 16:23
 * @desc
 */
@Api(tags = "9-92 [内部接口]用户信息相关接口")
@RequestMapping("facade/user/auth")
@RestController
@Slf4j
public class UserAuthFacadeController {

    @Resource
    private UserAuthService userAuthService;

    @ApiOperation(value = "9-92-01 获取微信用户信息", notes = "获取微信用户信息(只可用于微信公众号的openId获取是否存在对应信息)")
    @ApiImplicitParam(name = "openId", value = "微信用户的openId")
    @GetMapping("/info")
    public ResponseEntity<UserAuth> selectByUserAuth(@RequestParam("openId") String openId) {
        return ResponseEntity.ok(userAuthService.selectByUserAuth(AppConst.LOGIN_TYPE.WEIXIN_OPENID, openId));
    }

    @ApiOperation(value = "9-92-02 根据unionId获取微信用户信息", notes = "获取微信用户信息(适用于微信开放平台根据unionId获取信息)")
    @ApiImplicitParam(name = "unionId", value = "微信用户的unionId")
    @GetMapping("/info/unionId")
    public ResponseEntity<UserAuth> selectUserAuthByUnionId(@RequestParam("unionId") String unionId) {
        return ResponseEntity.ok(userAuthService.selectByUserAuth(AppConst.LOGIN_TYPE.WEIXIN, unionId));
    }

    @ApiOperation(value = "9-92-03 根据userId获取微信用户信息", notes = "获取微信用户信息(根据APP用户获取对应APP内的openId)")
    @ApiImplicitParam(name = "userId", value = "userId")
    @GetMapping("/info/openId")
    public ResponseEntity<UserAuth> selectUserAuthByOpenId(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(userAuthService.selectByUserAuth(userId, AppConst.LOGIN_TYPE.APP_OPENID));
    }

    @ApiOperation(value = "9-92-04 根据userId获取微信小程序用户信息")
    @ApiImplicitParam(name = "userId", value = "userId")
    @GetMapping("/info/selectAppletUserAuthByUserId")
    public ResponseEntity<UserAuth> selectAppletUserAuthByUserId(@RequestParam("userId") Long userId, @RequestParam("type") Byte type) {
        return ResponseEntity.ok(userAuthService.selectByUserAuth(userId, type));
    }

    @ApiOperation(value = "9-92-05 根据openId获取微信小程序用户信息")
    @ApiImplicitParam(name = "openId", value = "openId")
    @GetMapping("/info/selectAppletUserAuthByOpenId")
    public ResponseEntity<UserAuth> selectAppletUserAuthByOpenId(@RequestParam("openId") String openId,
                                                                 @RequestParam("type") Byte type) {
        return ResponseEntity.ok(userAuthService.selectByUserAuth(type, openId));
    }

    @ApiOperation(value = "9-92-06 根据userId获取微信公众号用户信息", notes = "获取微信用户信息")
    @ApiImplicitParam(name = "userId", value = "userId")
    @GetMapping("/info/wechat/openId")
    public ResponseEntity<UserAuth> selectUserAuthByUserId(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(userAuthService.selectByUserAuth(userId, AppConst.LOGIN_TYPE.WEIXIN_OPENID));
    }
}
