package com.bxm.localnews.user.controller;

import java.util.List;

import com.bxm.localnews.user.dto.UserBaseInfoDTO;
import com.bxm.localnews.user.dto.UserInfoDTO;
import com.bxm.localnews.user.param.TempUserParam;
import com.bxm.localnews.user.service.UserBaseInfoService;
import com.bxm.localnews.user.service.UserService;
import com.bxm.localnews.user.vo.User;
import com.bxm.newidea.component.vo.Message;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author zhaoyadong 2019/3/2 10:30
 * @desc
 */
@Api(tags = "9-93 [内部接口]用户信息相关接口")
@RequestMapping("facade/user")
@RestController
@Slf4j
public class UserFacadeController {

    @Resource
    private UserService userService;

    @Resource
    private UserBaseInfoService userBaseInfoService;

    @ApiOperation(value = "9-93-01 获取用户缓存信息", notes = "获取用户缓存信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id")
    @GetMapping("/info")
    public ResponseEntity<UserInfoDTO> selectUserFromCache(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(userService.getUserFromRedisDB(userId));
    }

    @ApiOperation(value = "9-93-02 获取用户默认头像", notes = "获取用户默认头像", httpMethod = "GET")
    @GetMapping("/headimg")
    public ResponseEntity<String> getDefaultHeadImgUrl() {
        return ResponseEntity.ok(userService.getDefaultHeadImgUrl());
    }

    @ApiOperation(value = "9-93-03 获取用户详细信息", notes = "获取用户详细信息", httpMethod = "GET")
    @GetMapping("/detail")
    public ResponseEntity<User> selectByPrimaryKey(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(userService.selectByPrimaryKey(userId));
    }

    @ApiOperation(value = "9-93-04 判断unionId是否被使用", notes = "判断unionId是否被使用")
    @RequestMapping(value = "/unionId", method = {RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<Boolean> checkUnionIdIsUser(@RequestParam("unionId") String unionId) {
        return ResponseEntity.ok(userService.checkUnionIdIsUser(unionId));
    }

    @ApiOperation(value = "9-93-05 创建用户", notes = "通过微信相关登陆创建用户信息")
    @PostMapping("/create")
    public ResponseEntity<Message> createUser(@RequestBody TempUserParam tempUserParam) {
        return ResponseEntity.ok(userService.createUser(tempUserParam));
    }

    @ApiOperation(value = "9-93-06 获取个人相关信息", notes = "包含姓名、头像、金币、签到信息、邀请人数")
    @GetMapping("/base/info")
    public ResponseEntity<UserBaseInfoDTO> getUserBaseInfo(Long userId, int platform) {
        return ResponseEntity.ok(userBaseInfoService.getUserInfoForWST(userId, platform));
    }

    @ApiOperation(value = "9-93-06 用户是否是临时用户", notes = "true：表示是临时用户 false：表示是永久用户")
    @GetMapping("/temp")
    public ResponseEntity<Boolean> isTempUser(Long userId) {
        return ResponseEntity.ok(userService.isTempUser(userId));
    }

    @ApiOperation(value = "9-93-07 用户是否是风险用户", notes = "true：表示是风险用户 false：表示是临时用户")
    @GetMapping("/risk")
    public ResponseEntity<Boolean> isRiskUser(Long userId) {
        return ResponseEntity.ok(userService.isRiskUser(userId));
    }

    @ApiOperation(value = "9-93-10 帖子、评论数修改", notes = "帖子、评论数修改, type：1帖子+1 2帖子-1 3评论+1 4评论-1")
    @PostMapping("/addPostReplyNum")
    public ResponseEntity<Boolean> addPostReplyNum(@RequestParam("userId") Long userId, @RequestParam("type") Integer type) {
        return ResponseEntity.ok(userService.addPostReplyNum(userId, type));
    }

    @ApiOperation(value = "9-93-11 更新用户信息【万事通小程序授权登陆】", notes = "")
    @PostMapping("/update")
    public ResponseEntity<Message> updateUser(@RequestBody TempUserParam tempUserParam) {
        return ResponseEntity.ok(userService.updateUser(tempUserParam));
    }

    @ApiOperation(value = "9-93-12 获取虚拟用户", notes = "")
    @PostMapping("/getVirtualUserList")
    public ResponseEntity<List<UserInfoDTO>> getVirtualUserList(@RequestParam("num") Integer num) {
        return ResponseEntity.ok(userService.getVirtualUserList(num));
    }
}
