/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.ImgDTO;
import com.bxm.localnews.user.dto.NoteDTO;
import com.bxm.localnews.user.dto.UserImgDTO;
import com.bxm.localnews.user.facade.UserNewsFeignService;
import com.bxm.localnews.user.vo.UserLikeVo;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserNewsIntegrationService
extends BaseService {
    @Autowired
    private UserNewsFeignService userNewsFeignService;

    @Async
    public void initUserNewsImage(Long newUserId, Long defaultUserId) {
        this.userNewsFeignService.initUserImage(newUserId, defaultUserId);
    }

    public Integer getPublishPostNum(Long userId) {
        return this.userNewsFeignService.getPublishPostNum(userId);
    }

    public List<UserLikeVo> getLikeNumByUserIds(List<Long> userId) {
        ResponseEntity<List<UserLikeVo>> result = this.userNewsFeignService.getLikeNumByUserIds(userId);
        if (Objects.nonNull(result)) {
            return (List)result.getBody();
        }
        return Lists.newArrayList();
    }

    public Boolean verifySensitiveWord(String text) {
        ResponseEntity<Boolean> isSensitiveEntity = this.userNewsFeignService.verifySensitiveWord(text);
        return (Boolean)isSensitiveEntity.getBody();
    }

    public Map<Long, List<ImgDTO>> batchGetUserImg(List<Long> userIdList) {
        HashMap<Long, List<ImgDTO>> imgMap = new HashMap<Long, List<ImgDTO>>();
        ResponseEntity<List<UserImgDTO>> userImgListEntity = this.userNewsFeignService.batchGetUserImg(userIdList, null);
        List userImgDTOList = (List)userImgListEntity.getBody();
        if (!CollectionUtils.isEmpty((Collection)userImgDTOList)) {
            userImgDTOList.forEach(e -> {
                if (e.getImgDtoList().size() >= 4) {
                    imgMap.put(e.getUserId(), this.subImgList(e.getImgDtoList(), 4));
                }
            });
        }
        return imgMap;
    }

    public Map<Long, List<ImgDTO>> batchGetAllUserImg(List<Long> userIdList, Long userId) {
        HashMap<Long, List<ImgDTO>> imgMap = new HashMap<Long, List<ImgDTO>>();
        ResponseEntity<List<UserImgDTO>> userImgListEntity = this.userNewsFeignService.batchGetUserImg(userIdList, userId);
        List userImgDTOList = (List)userImgListEntity.getBody();
        if (!CollectionUtils.isEmpty((Collection)userImgDTOList)) {
            userImgDTOList.forEach(e -> imgMap.put(e.getUserId(), this.subImgList(e.getImgDtoList(), 4)));
        }
        return imgMap;
    }

    public Map<Long, NoteDTO> batchGetUserNote(List<Long> userIdList, Long userId) {
        HashMap<Long, NoteDTO> noteMap = new HashMap<Long, NoteDTO>();
        ResponseEntity<List<NoteDTO>> userNoteEntity = this.userNewsFeignService.batchGetUserNote(userIdList, userId);
        List noteDTOList = (List)userNoteEntity.getBody();
        if (!CollectionUtils.isEmpty((Collection)noteDTOList)) {
            noteDTOList.forEach(e -> noteMap.put(e.getUserId(), (NoteDTO)e));
        }
        return noteMap;
    }

    private List<ImgDTO> subImgList(List<ImgDTO> imgDTOList, int limit) {
        if (imgDTOList.size() >= limit) {
            return imgDTOList.subList(0, limit);
        }
        return imgDTOList;
    }
}

