package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.facade.fallback.LocationFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/3/1 14:09
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = LocationFallbackFactory.class, primary = false)
public interface LocationFeignService {

    @GetMapping("/facade/location/info")
    ResponseEntity<LocationDTO> getLocationByGeocode(@RequestParam("code") String code);
}
