package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.facade.fallback.MerchantFallbackFactory;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author pf.w
 * @date 2020/7/16 12:02
 */
@FeignClient(value = "localnews-merchant", fallbackFactory = MerchantFallbackFactory.class, primary = false)
public interface MerchantFeignService {

    @GetMapping("/facade/merchant/userMerchant")
    ResponseEntity<MerchantUserDTO> userMerchantInfo(@RequestParam("userId") Long userId);

    @PostMapping("facade/merchant/insertMerchantInvite")
    ResponseEntity<Boolean> insertMerchantInvite(@RequestBody UserInviteHistoryBean userInviteHistoryBean);

    @GetMapping("facade/merchant/updateInvitedUserIdVip")
    ResponseEntity<Boolean> updateInvitedUserIdVip(@RequestParam("userId") Long userId, @RequestParam("activeType") String activeType);


}
