package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.dto.CommodityGoodsDTO;
import com.bxm.localnews.user.facade.CommodityFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * 商品服务调用出错后的容错处理
 * @author liujia
 * @date 2020/05/14 14:47
 */
@Component
@Slf4j
public class CommodityFallbackFactory implements FallbackFactory<CommodityFeignService> {
    @Override
    public CommodityFeignService create(Throwable throwable) {
        return new CommodityFeignService() {

            @Override
            public ResponseEntity<CommodityGoodsDTO> getBriefGoodsById(String goodsId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
