package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.user.dto.TopicFacadeVO;
import com.bxm.localnews.user.facade.ForumPostFacadeService;
import com.bxm.localnews.user.vo.ForumPostVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ForumPostFallbackFactory implements FallbackFactory<ForumPostFacadeService> {
    @Override
    public ForumPostFacadeService create(Throwable throwable) {
        return new ForumPostFacadeService() {

            @Override
            public ResponseEntity<TopicFacadeVO> getTopicById(Long id) {
                return ResponseEntity.ok(TopicFacadeVO.builder().build());
            }

            @Override
            public ResponseEntity<ForumPostBriefInfoDto> getPostWithoutDetail(Long postId) {
                return ResponseEntity.ok(ForumPostBriefInfoDto.builder().build());
            }

            @Override
            public ResponseEntity<ForumPostVo> getForumPostById(Long id) {
                return ResponseEntity.ok(new ForumPostVo());
            }
        };
    }
}
