package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.facade.IMFacadeService;
import com.bxm.localnews.user.vo.ImChatroom;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class ImFallbackFactory implements FallbackFactory<IMFacadeService> {
    @Override
    public IMFacadeService create(Throwable throwable) {
        return new IMFacadeService() {
            @Override
            public ResponseEntity<ImChatroom> getChatRoom(String areaCode) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body(null);
            }

            @Override
            public ResponseEntity<Boolean> syncUser(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body(null);
            }
        };
    }
}
