package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.facade.MerchantFeignService;
import com.bxm.localnews.user.model.MerchantUserDTO;
import com.bxm.localnews.user.vo.UserInviteHistoryBean;
import feign.hystrix.FallbackFactory;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author pf.w
 * @date 2020/7/16 12:03
 */
@Component
@Log4j2
public class MerchantFallbackFactory implements FallbackFactory<MerchantFeignService> {
    @Override
    public MerchantFeignService create(Throwable throwable) {
        return new MerchantFeignService() {
            @Override
            public ResponseEntity<MerchantUserDTO> userMerchantInfo(Long userId) {
                log.error(throwable.getMessage(), throwable);

                MerchantUserDTO merchantUserDTO = new MerchantUserDTO();
                merchantUserDTO.setUserId(userId);
                merchantUserDTO.setMerchantStatus(0);
                return ResponseEntity.ok(merchantUserDTO);
            }

            @Override
            public ResponseEntity<Boolean> insertMerchantInvite(UserInviteHistoryBean userInviteHistoryBean) {
                return ResponseEntity.ok(true);
            }

            @Override
            public ResponseEntity<Boolean> updateInvitedUserIdVip(Long userId, String activeType) {
                return ResponseEntity.ok(true);
            }


        };

    }
}
